/*
 * Decompiled with CFR 0.152.
 */
package com.xiangcao.xiangcaomengjia;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.xiangcao.xiangcaomengjia.config.PriceVariationData;
import com.xiangcao.xiangcaomengjia.config.SellingBinConfig;
import com.xiangcao.xiangcaomengjia.config.SellingBinConfigClient;
import com.xiangcao.xiangcaomengjia.config.XiangcaoTierConfig;
import com.xiangcao.xiangcaomengjia.network.PacketOpenConfigScreen;
import com.xiangcao.xiangcaomengjia.network.PacketTradeList;
import com.xiangcao.xiangcaomengjia.network.XiangcaoNet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="xiangcaomengjia", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PriceVariationEvents {
    private static long lastPeriodCheckTick = 0L;

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher d = event.getDispatcher();
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"xiangcaomengjia").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"refreshPrice").requires(cs -> cs.m_6761_(2))).executes(ctx -> {
            if (!XiangcaoTierConfig.priceVariationEnabled()) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u4ef7\u683c\u53d8\u52a8\u672a\u5f00\u542f"));
                return 0;
            }
            if (!XiangcaoTierConfig.priceManualRefreshAllowed()) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u672a\u5141\u8bb8\u624b\u52a8\u5237\u65b0"));
                return 0;
            }
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            if (level instanceof ServerLevel) {
                ServerLevel sl = level;
                PriceVariationData.get(sl).refresh(sl);
                XiangcaoNet.broadcastPriceMultiplier(sl);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u4ef7\u683c\u500d\u7387\u5df2\u5237\u65b0"), true);
                return 1;
            }
            return 0;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"config").requires(cs -> cs.m_6761_(2))).executes(ctx -> {
            Entity patt3067$temp = ((CommandSourceStack)ctx.getSource()).m_81373_();
            if (patt3067$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt3067$temp;
                XiangcaoNet.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketOpenConfigScreen());
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u4ec5\u73a9\u5bb6\u53ef\u6253\u5f00\u914d\u7f6e\u754c\u9762"));
            return 0;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(cs -> cs.m_6761_(2))).executes(ctx -> {
            SellingBinConfig.getInstance().reloadConfig();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"gui.xiangcaomengjia.config.reloaded"), true);
            return 1;
        })));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (XiangcaoTierConfig.priceVariationEnabled()) {
                XiangcaoNet.syncPriceMultiplierToPlayer(player2);
            }
            List<SellingBinConfigClient.TradeEntry> list = SellingBinConfig.getInstance().getTradeRules().stream().map(r -> new SellingBinConfigClient.TradeEntry(r.inputItem, r.inputCount, r.sdmValue)).collect(Collectors.toList());
            XiangcaoNet.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PacketTradeList(list));
        }
    }

    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        if (!XiangcaoTierConfig.priceVariationEnabled() || !XiangcaoTierConfig.priceRefreshOnSleep()) {
            return;
        }
        Level level = event.getEntity().m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            PriceVariationData.get(sl).refresh(sl);
            XiangcaoNet.broadcastPriceMultiplier(sl);
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!(event.level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)event.level;
        if (!XiangcaoTierConfig.priceVariationEnabled()) {
            return;
        }
        int periodMin = XiangcaoTierConfig.priceRefreshPeriodMinutes();
        if (periodMin <= 0) {
            return;
        }
        long tick = level.m_46467_();
        if (tick - lastPeriodCheckTick < 1200L) {
            return;
        }
        lastPeriodCheckTick = tick;
        PriceVariationData data = PriceVariationData.get(level);
        long periodTicks = (long)periodMin * 20L * 60L;
        if (tick - data.getLastRefreshTick() >= periodTicks) {
            data.refresh(level);
            XiangcaoNet.broadcastPriceMultiplier(level);
        }
    }
}

